/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.dbgp;

import com.aptana.core.util.StringUtil;
import com.aptana.php.debug.core.preferences.PHPDebugPreferencesUtil;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org2.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugDebuggerConfiguration;
import org2.eclipse.php.internal.debug.ui.preferences.AbstractDebuggerConfigurationDialog;

public class XDebugConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    private ComboListener comboListener;
    private Text portTextBox;
    private Button showGlobals;
    private Spinner variableDepth;
    private Spinner maxChildren;
    private Button useMultiSession;
    private Combo acceptRemoteSession;
    private Combo captureStdout;
    private Combo captureStderr;
    private Button useProxy;
    private Text idekeyTextBox;
    private Text proxyTextBox;
    private XDebugDebuggerConfiguration xdebugDebuggerConfiguration;
    private int originalPort;

    public XDebugConfigurationDialog(XDebugDebuggerConfiguration xdebugDebuggerConfiguration, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.xdebugDebuggerConfiguration = xdebugDebuggerConfiguration;
    }

    private void toggleProxyFields(boolean selection) {
        this.idekeyTextBox.setEnabled(selection);
        this.proxyTextBox.setEnabled(selection);
    }

    protected Control createDialogArea(Composite parent) {
        this.comboListener = new ComboListener();
        parent = (Composite)super.createDialogArea(parent);
        this.setTitle(PHPDebugCoreMessages.XDebugConfigurationDialog_mainTitle);
        Composite[] subsections = this.createSubsections(parent, PHPDebugCoreMessages.XDebugConfigurationDialog_generalGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_captureGroup, PHPDebugCoreMessages.XDebugConfigurationDialog_proxyGroup);
        Composite mainSubSection = subsections[0];
        this.addLabelControl(mainSubSection, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, "com.aptana.php.debug.epl.xdebug_port");
        this.portTextBox = this.addNumTextField(mainSubSection, "com.aptana.php.debug.epl.xdebug_port", 5, 2, false);
        this.showGlobals = this.addCheckBox(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_showSuperGlobals, "com.aptana.php.debug.epl.xdebug_showSuperGlobals", 0);
        this.addLabelControl(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_maxArrayDepth, "com.aptana.php.debug.epl.xdebug_arrayDepth");
        this.variableDepth = this.addVariableLevel(mainSubSection, "com.aptana.php.debug.epl.xdebug_arrayDepth", 1, 150, 2);
        this.addLabelControl(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_maxChildren, "com.aptana.php.debug.epl.xdebug_children");
        this.maxChildren = this.addVariableLevel(mainSubSection, "com.aptana.php.debug.epl.xdebug_children", 1, 500, 2);
        this.useMultiSession = this.addCheckBox(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_useMultisession, "com.aptana.php.debug.epl.xdebug_multisession", 0);
        this.acceptRemoteSession = this.addComboField(mainSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSession, XDebugPreferenceMgr.remoteSessionOptions);
        Composite captureSubSection = subsections[1];
        this.captureStdout = this.addComboField(captureSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_captureStdout, XDebugPreferenceMgr.captureOutputOptions);
        this.captureStderr = this.addComboField(captureSubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_captureStderr, XDebugPreferenceMgr.captureOutputOptions);
        Composite proxySubSection = subsections[2];
        this.useProxy = this.addCheckBox(proxySubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_useProxy, "com.aptana.php.debug.epl.xdebug_useproxy", 0);
        this.useProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XDebugConfigurationDialog.this.toggleProxyFields(XDebugConfigurationDialog.this.useProxy.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                XDebugConfigurationDialog.this.toggleProxyFields(XDebugConfigurationDialog.this.useProxy.getSelection());
            }
        });
        this.addLabelControl(proxySubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_idekey, "com.aptana.php.debug.epl.xdebug_idekey");
        this.idekeyTextBox = this.addATextField(proxySubSection, "com.aptana.php.debug.epl.xdebug_idekey", 100, 2);
        this.addLabelControl(proxySubSection, PHPDebugCoreMessages.XDebugConfigurationDialog_proxy, "com.aptana.php.debug.epl.xdebug_proxy");
        this.proxyTextBox = this.addATextField(proxySubSection, "com.aptana.php.debug.epl.xdebug_proxy", 100, 2);
        GridData gridData = (GridData)this.proxyTextBox.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(90);
        this.internalInitializeValues();
        return parent;
    }

    private Text addNumTextField(Composite parent, String key, int textLimit, int horizontalIndent, boolean isTimeout) {
        Text text = super.addTextField(parent, key, textLimit, horizontalIndent);
        text.addModifyListener((ModifyListener)new NumFieldValidateListener(isTimeout));
        return text;
    }

    private Text addATextField(Composite parent, String key, int minWidth, int horizontalIndent) {
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        GridData data = new GridData(768);
        data.horizontalIndent = horizontalIndent;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = minWidth;
        textBox.setLayoutData((Object)data);
        return textBox;
    }

    private Combo addComboField(Composite parent, String text, String[] options) {
        this.addLabelControl(parent, text, null);
        Combo comboBox = new Combo(parent, 12);
        GridData data = new GridData(768);
        data.horizontalIndent = 1;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        comboBox.setLayoutData((Object)data);
        comboBox.setItems(options);
        comboBox.addSelectionListener((SelectionListener)this.comboListener);
        return comboBox;
    }

    protected Composite[] createSubsections(Composite parent, String label, String label2, String label3) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        Group group = new Group(parent, 32);
        group.setText(label);
        data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Group group2 = new Group(parent, 32);
        group2.setText(label2);
        data = new GridData(4, 4, true, true);
        group2.setLayoutData((Object)data);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 3;
        group2.setLayout((Layout)layout2);
        Group group3 = new Group(parent, 32);
        group3.setText(label3);
        data = new GridData(4, 4, true, true);
        group3.setLayoutData((Object)data);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 2;
        group3.setLayout((Layout)layout3);
        return new Group[]{group, group2, group3};
    }

    protected void okPressed() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.php.debug.epl");
        prefs.put("com.aptana.php.debug.epl.xdebug_port", this.portTextBox.getText());
        prefs.putBoolean("com.aptana.php.debug.epl.xdebug_showSuperGlobals", this.showGlobals.getSelection());
        prefs.putInt("com.aptana.php.debug.epl.xdebug_arrayDepth", this.variableDepth.getSelection());
        prefs.putInt("com.aptana.php.debug.epl.xdebug_children", this.maxChildren.getSelection());
        prefs.putBoolean("com.aptana.php.debug.epl.xdebug_multisession", this.useMultiSession.getSelection());
        prefs.putInt("com.aptana.php.debug.epl.xdebug_remotesession", this.acceptRemoteSession.getSelectionIndex());
        prefs.putInt("com.aptana.php.debug.epl.xdebug_capturestdout", this.captureStdout.getSelectionIndex());
        prefs.putInt("com.aptana.php.debug.epl.xdebug_capturestderr", this.captureStderr.getSelectionIndex());
        prefs.putBoolean("com.aptana.php.debug.epl.xdebug_useproxy", this.useProxy.getSelection());
        prefs.put("com.aptana.php.debug.epl.xdebug_idekey", this.idekeyTextBox.getText());
        prefs.put("com.aptana.php.debug.epl.xdebug_proxy", this.proxyTextBox.getText());
        DBGpProxyHandler.instance.configure();
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PHPDebugEPLPlugin.logError(e);
        }
        super.okPressed();
    }

    private void internalInitializeValues() {
        this.originalPort = PHPDebugPreferencesUtil.getInt("com.aptana.php.debug.epl.xdebug_port", 0);
        if (this.originalPort == 0) {
            XDebugPreferenceMgr.setDefaults();
            this.originalPort = PHPDebugPreferencesUtil.getInt("com.aptana.php.debug.epl.xdebug_port", 0);
        }
        this.portTextBox.setText(Integer.toString(this.originalPort));
        this.showGlobals.setSelection(PHPDebugPreferencesUtil.getBoolean("com.aptana.php.debug.epl.xdebug_showSuperGlobals", true));
        this.useMultiSession.setSelection(PHPDebugPreferencesUtil.getBoolean("com.aptana.php.debug.epl.xdebug_multisession", true));
        this.variableDepth.setSelection(PHPDebugPreferencesUtil.getInt("com.aptana.php.debug.epl.xdebug_arrayDepth", 0));
        this.maxChildren.setSelection(PHPDebugPreferencesUtil.getInt("com.aptana.php.debug.epl.xdebug_children", 0));
        this.acceptRemoteSession.select(PHPDebugPreferencesUtil.getInt("com.aptana.php.debug.epl.xdebug_remotesession", 0));
        this.captureStdout.select(PHPDebugPreferencesUtil.getInt("com.aptana.php.debug.epl.xdebug_capturestdout", 0));
        this.captureStderr.select(PHPDebugPreferencesUtil.getInt("com.aptana.php.debug.epl.xdebug_capturestderr", 0));
        boolean useProxyState = PHPDebugPreferencesUtil.getBoolean("com.aptana.php.debug.epl.xdebug_useproxy", false);
        this.useProxy.setSelection(useProxyState);
        String ideKey = PHPDebugPreferencesUtil.getString("com.aptana.php.debug.epl.xdebug_idekey", null);
        if (StringUtil.isEmpty((String)ideKey)) {
            ideKey = DBGpProxyHandler.instance.generateIDEKey();
        }
        this.idekeyTextBox.setText(ideKey);
        this.proxyTextBox.setText(PHPDebugPreferencesUtil.getString("com.aptana.php.debug.epl.xdebug_proxy", ""));
        this.toggleProxyFields(useProxyState);
    }

    private Spinner addVariableLevel(Composite parent, String key, int min, int max, int horizontalIndent) {
        Spinner spin = new Spinner(parent, 2560);
        spin.setData((Object)key);
        spin.setMinimum(min);
        spin.setMaximum(max);
        GridData data = new GridData();
        data.horizontalIndent = horizontalIndent;
        data.horizontalSpan = 2;
        spin.setLayoutData((Object)data);
        spin.setIncrement(1);
        spin.setPageIncrement(3);
        return spin;
    }

    static /* synthetic */ Combo access$2(XDebugConfigurationDialog xDebugConfigurationDialog) {
        return xDebugConfigurationDialog.captureStderr;
    }

    class ComboListener
    implements SelectionListener {
        ComboListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == XDebugConfigurationDialog.this.acceptRemoteSession || source != XDebugConfigurationDialog.this.captureStdout) {
                // empty if block
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == XDebugConfigurationDialog.this.acceptRemoteSession || source != XDebugConfigurationDialog.this.captureStdout) {
                // empty if block
            }
        }
    }

    class NumFieldValidateListener
    implements ModifyListener {
        private boolean timeoutField;

        NumFieldValidateListener(boolean isTimeout) {
            this.timeoutField = isTimeout;
        }

        public void modifyText(ModifyEvent e) {
            Integer iValue;
            String errorMessage = null;
            boolean valid = true;
            String value = ((Text)e.widget).getText();
            try {
                iValue = new Integer(value);
                int i = iValue;
                if (!this.timeoutField) {
                    if (i <= 0 || i > 65535) {
                        valid = false;
                        errorMessage = PHPDebugCoreMessages.XDebugConfigurationDialog_invalidPortRange;
                    }
                } else if (i < 10 || i > 100000) {
                    valid = false;
                    errorMessage = PHPDebugCoreMessages.XDebugConfigurationDialog_invalidTimeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                valid = false;
                errorMessage = !this.timeoutField ? PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort : PHPDebugCoreMessages.XDebugConfigurationDialog_invalidTimeoutValue;
            }
            if (valid && !this.timeoutField && (iValue = new Integer(value)) != XDebugConfigurationDialog.this.originalPort && !AbstractDebuggerCommunicationDaemon.isPortAvailable(iValue)) {
                valid = false;
                errorMessage = PHPDebugCoreMessages.DebuggerConfigurationDialog_portInUse;
            }
            XDebugConfigurationDialog.this.setErrorMessage(errorMessage);
            Button bt = XDebugConfigurationDialog.this.getButton(0);
            if (bt != null) {
                bt.setEnabled(valid);
            }
        }
    }
}

